local overrides = {
	["ksg"] = {
		["wpn_fps_sho_ksg_b_legendary"] = "wpn_fps_sho_ksg_b_standard"
	},
	["r870"] = {
		["wpn_fps_shot_r870_b_legendary"] = "wpn_fps_shot_r870_b_long"
	},
	["new_m14"] = {
		["wpn_fps_ass_m14_b_legendary"] = "wpn_fps_ass_m14_b_standard",
		["wpn_fps_ass_m14_body_legendary"] = "	wpn_fps_ass_m14_body_dmr"
	},
	["m16"] = {
		["wpn_fps_ass_m16_b_legend"] = "wpm_fps_m4_uupg_b_medium_vanilla",
		["wpn_fps_ass_m16_s_legend"] = "wpm_fps_m16_s_solid_vanilla",
		["wpn_fps_ass_m16_fg_legend"] = "wpn_fps_ass_m16_fg_standard"
	},
	["ak74"] = {
		["wpn_fps_ass_74_b_legend"] = "wpn_fps_ass_74_b_standard"
	},
	["tecci"] = {
		["wpn_fps_ass_tecci_b_legend"] = "wpn_fps_ass_tecci_b_standard"
	},
	["boot"] = {
		["wpn_fps_sho_boot_b_legendary"] = "wpn_fps_sho_boot_b_standard",
		["wpn_fps_sho_boot_fg_legendary"] = "wpn_fps_sho_boot_fg_standard"
	},
	["par"] = {
		["wpn_fps_lmg_svinet_b_standard"] = "wpn_fps_lmg_par_b_standard"
	},
	["model70"] = {
		["wpn_fps_snp_model70_s_legend"] = "wpn_fps_snp_model70_s_standard"
	},
	["x_1911"] = {
		["wpn_fps_pis_1911_fl_legendary"] = "wpn_fps_upg_fl_pis_crimson"
	},
	["deagle"] = {
		["wpn_fps_pis_deagle_b_legend"] = "wpn_fps_pis_deagle_b_standard"
	},
	["serbu"] = {
		["wpn_fps_shot_shorty_b_legendary"] = "wpn_fps_shot_r870_b_short",
		["wpn_fps_shot_shorty_fg_legendary"] = "wpn_fps_shot_r870_fg_small"
	},
	["judge"] = {
		["wpn_fps_pis_judge_g_legend"] = "wpn_fps_pis_judge_g_standard",
		["wpn_fps_pis_judge_b_legend"] = "wpn_fps_pis_judge_b_standard"
	}
}

if RequiredScript == "lib/network/base/basenetworksession" then
	local o_check_send_outfit = BaseNetworkSession.check_send_outfit
	function BaseNetworkSession:check_send_outfit(peer)
		Global.IS_SENDING_OUTFIT = true
		o_check_send_outfit(self, peer)
		Global.IS_SENDING_OUTFIT = false
	end
 
elseif RequiredScript == "lib/managers/blackmarketmanager" then
	local o_equipped_primary = BlackMarketManager.equipped_primary
	function BlackMarketManager:equipped_primary()
		local current_weapon_data = self:equipped_weapon("primaries", "primary")

		local fake_weapon_data = {
			["weapon_id"] = current_weapon_data["weapon_id"],
			["equipped"] = true,
			["global_values" ] = {},
			["factory_id"] = current_weapon_data["factory_id"],
			["blueprint"] = {}
		}

		for k,v in pairs(current_weapon_data["blueprint"]) do
			fake_weapon_data["blueprint"][k] = v
		end

		if current_weapon_data["cosmetics"] ~= nil then
			fake_weapon_data["cosmetics"] = {}
			for k,v in pairs(current_weapon_data["cosmetics"]) do
				fake_weapon_data["cosmetics"][k] = v
			end
		end

		if overrides[fake_weapon_data["weapon_id"]] ~= nil then
			for k,v in pairs(fake_weapon_data["blueprint"]) do
				if overrides[fake_weapon_data["weapon_id"]][v] ~= nil then
					fake_weapon_data["blueprint"][k] = overrides[fake_weapon_data["weapon_id"]][v]
				end
			end
		end

		return Global.IS_SENDING_OUTFIT and fake_weapon_data or o_equipped_primary(self)
	end
 
	local o_equipped_secondary = BlackMarketManager.equipped_secondary
	function BlackMarketManager:equipped_secondary()
		local current_weapon_data = self:equipped_weapon("secondaries", "secondary")
		
		local fake_weapon_data = {
			["weapon_id"] = current_weapon_data["weapon_id"],
			["equipped"] = true,
			["global_values" ] = {},
			["factory_id"] = current_weapon_data["factory_id"],
			["blueprint"] = {}
		}

		for k,v in pairs(current_weapon_data["blueprint"]) do
			fake_weapon_data["blueprint"][k] = v
		end

		if current_weapon_data["cosmetics"] ~= nil then
			fake_weapon_data["cosmetics"] = {}
			for k,v in pairs(current_weapon_data["cosmetics"]) do
				fake_weapon_data["cosmetics"][k] = v
			end
		end

		if overrides[fake_weapon_data["weapon_id"]] ~= nil then
			for k,v in pairs(fake_weapon_data["blueprint"]) do
				if overrides[fake_weapon_data["weapon_id"]][v] ~= nil then
					fake_weapon_data["blueprint"][k] = overrides[fake_weapon_data["weapon_id"]][v]
				end
			end
		end

		return Global.IS_SENDING_OUTFIT and fake_weapon_data or o_equipped_secondary(self)
	end
end